function colr = pixelate(A,lc,rc,tr,br,n)
% "Pixelate" a rectangular section of an image. Each block of the pixelated
% area has the "average color" of the block.  Assume an image is displayed
% in the figure window with hold on.
%
% A:  RGB data of the image, a 3-d uint8 array.
% lc: Leftmost column index of user-selected area for pixelation
% rc: rightmost column index of user-selected area for pixelation
% tr: topmost row index of user-selected area for pixelation
% br: bottommost row index of user-selected area for pixelation
% n:  Block size, i.e., each block is n-by-n pixels (n rows by n cols).
%     n is a positive integer value.
%      
% The actual area to be pixelated should be trimmed such that its number of 
%   rows and number of columns of pixels are each a multiple of n, starting 
%   from the top left corner (crop the right and bottom).  Then the number
%   of rows of blocks (nrb) and the number of columns of blocks (ncb) are
%   each an intger. If either nrb or ncb is less than 5, do not pixelate 
%   and stop program execution with the error message 
%   'Use smaller block size (n) or select larger area'
% 
% If pixelation can be done, then colr is the nrb-by-ncb-by-3 array storing
% the RGB color of the nrb*ncb blocks in the pixelation.  Each value in 
% colr is of type double in the range of 0 to 1.
%   colr(i,j,1) stores the average red intensity of the pixels in block i,j
%   colr(i,j,2) stores the average green intensity of the pixels in block i,j
%   colr(i,j,3) stores the average blue intensity of the pixels in block i,j
%
% Call DrawRectNoBorder to draw the pixelation on the image.  

